---
obsidianUIMode: preview
---

How combat plays out against specific types of monsters in other 5e games changes depending on the level of the characters. Character power progression isn't smooth and linear across levels. Rather, it spikes at particular levels, potentially changing the outcome of a battle dramatically. As an example, the jump from 4th to 5th level gives melee characters twice as many attacks, while spellcasters gain access to spells such as *fireball*, significantly raising a party's damage output overnight. Recognizing when and how these changes take place can help GMs understand and prepare for these shifts in game play.

## 1st Level

Though not identified as its own tier of play in the fifth edition core rules, games at 1st level are entirely different from games at later levels. Characters of 1st level have few resources—hit points in particular. Creatures of CR 1/2 can kill 1st-level characters with a single critical hit, and 1st-level spellcasters have few spells able to control more than one or two monsters.

When designing combat encounters at 1st level, be wary of using foes higher than CR 1/4, and lean toward running fewer monsters than characters. A CR 1/2 creature might make a decent boss monster for 1st-level characters, but a CR 1 monster might knock characters unconscious with a single hit-or even kill them completely.

Even when running a published adventure for 1st-level characters, take note of the encounters it offers. Many such adventures include potentially deadly encounters at 1st level, so adjust them accordingly by running lower-CR monsters and fewer of them.

Creatures of CR 1/8 to CR 1/2 work well for 1st-level characters, including bandits, cultists, and skeletons, with maybe a thug for a boss.

## 2nd through 4th Level

At 2nd through 4th level, encounters most often play out as expected for a heroic fantasy roleplaying game. Characters are robust enough to face a range of monsters and not get killed. Most characters have a single attack, or sometimes two if they fight with a weapon in each hand. Spells usually target one or two creatures.

Combat encounters of 2nd to 4th level are often the easiest to balance compared to other levels of play. Characters of 2nd through 4th level can typically handle a group of monsters from challenge rating 1/8 to CR 1, a pair of monsters of CR 2 or 3, or a single monster up to about CR 5.

Great foes at these levels include all of those appropriate for 1st-level characters, along with ogres, scouts, dire wolves, and veterans. Cult fanatics, hags, vampire spawn, ettins, and lamias can work well for bosses at this tier.

## 5th to 10th Level

At 5th level, character power spikes up. Fighters can attack twice, and can double that double attack with Action Surge. Spellcasters gain access to spells such as *fireball*, *spirit guardians*, and *hypnotic pattern*. As characters rise above 5th level, their capabilities increase quickly. Monks get Stunning Strike. Spellcasters learn spells able to take out a foe with a single failed saving throw, including *banishment* and *polymorph*.

At 5th level and above, you can no longer trust a lone nonlegendary monster to challenge a group of characters. Often a single spell, class feature, or volley of attacks can incapacitate or kill any such creature. Against large groups of foes, a casting of *fireball* or a use of Turn Undead can end the fight. Get comfortable with this change to how your encounters are going to play out, and use lightning rod monsters to let the characters show off these potent capabilities without ruining your fun.

At these levels, the heroes' defensive capabilities increase as well. Characters can fly, turn invisible, or block off entire sections of the battlefield with spells like *wall of fire*. Healing becomes plentiful. Paladins can protect entire parties with their defensive features. Even lower-level defensive features such as the *shield* spell can be used more often with a larger number of available spell slots.

At 5th level and above, a GM's understanding of the capabilities of the characters and how those capabilities relate to a monster's stat block is vital to building challenging encounters. Creatures who challenge characters at 5th level and above (roughly CR 4 and up) are usually more complicated than those of lower challenge ratings. Hard encounters put together using default encounter-building rules might be less challenging than expected.

Characters of 5th to 10th level can often take on hordes of foes of CR 1/4 to CR 1. They can usually survive battles against groups of CR 2 to CR 5 monsters, small groups of CR 6 to CR 10 foes, and single monsters up to CR 15.

Great foes at this tier include young dragons, giants, mages, and lower-CR demons and devils. Bosses can include medusas, lower-CR adult dragons, mid-CR demons and devils, and maybe even an archmage.

## 11th to 16th level

At 11th level, characters become superheroes. They have huge amounts of resources at their disposal to handle the hardest monsters in the game. The heroes' ability to control or incapacitate foes continues to increase, along with their ability to dish out tremendous amounts of damage.

The variance in power and capabilities between different groups at these levels of play is wide. Challenging battles can take significantly longer to run than those of lower levels. Monsters who feel like a good challenge often end up easier to defeat than expected, and characters at this level can often take out a single powerful boss with ease. Likewise, the characters have numerous options to mitigate the damage their foes deal—made worse by the fact that many published monsters appropriate for these levels deal too little damage for their challenge rating.

Characters at these levels can often take on large groups of monsters of up to CR 3, medium-sized groups of CR 6 to CR 10, small groups of CR 11 to CR 14, and single opponents of up to CR 21. Good foes at this tier include all of those mentioned previously, along with ancient dragons, higher-CR giants, liches, and high-CR demons and devils. And even at a high CR, a boss monster almost certainly wants some friends to defend against the characters.

## 17th to 20th level

From 17th level up, the characters are just short of godlike. They travel across worlds. They can often easily defeat any single monster of any challenge rating, unless the GM customizes that monster to face them. Characters at the highest levels have the strongest defenses imaginable, letting them absorb tremendous amounts of damage and wave off most detrimental effects. To build challenging encounters at these levels, GMs must customize those encounters around the powers and capabilities of the characters, and such battles can take a long time to run.

At these levels, characters can take on huge numbers of foes below CR 5, large groups of CR 6 to CR 10, medium-sized groups of CR 11 to CR 15, and bosses of CR 22 and above. Characters at these levels can fight—and triumph over—any monster in 5e, even when partnered with other monsters.
